/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBModuleLanguages = Object.create(STBModule.prototype);

STBModuleLanguages.name = "ModuleLanguages";

STBModuleLanguages.initDropdown = function() {
    try {
        var dropDown = $('.dropdown.dropdown-language').find('.dropdown-menu');

        if (dropDown.length > 0) {

            dropDown.each(function () {

                var obj = $(this),
                    linkWidth = obj.find('a'),
                    maxWidth = Math.max.apply(null, linkWidth.map(function () {
                        return $(this).outerWidth(true);
                    }).get());

                obj.css('min-width', maxWidth);
            });
        }

    } catch (e) {
        getStack(0, e);
    }
}


STBModuleLanguages.initLinks = function() {
    try {
        var parseLang = function (e) {
            e.preventDefault();
           location.href = $(this).attr("data-language-link");
        };

        $("a[data-language-link]").on('click', parseLang);

    } catch (e) {
        getStack(0, e);
    }
}

STBModuleLanguages.runOnReady = function() {
	STBModuleLanguages.initLinks();
	STBModuleLanguages.initDropdown();
}

STBModuleLanguages.runOnResize = function() {
	STBModuleLanguages.initDropdown();
}

site.registerModule(STBModuleLanguages);
